﻿using System;
using System.Collections.Generic;
using System.Dynamic;

namespace ExpandoExamples
{
    class Program
    {
        static void Main(string[] args)
        {
            // Listing 18-17. Przypisywanie wartości dynamicznym właściwościom
            dynamic dx = new ExpandoObject();
            dx.MyProperty = true;
            dx.AnotherProperty = 42;

            // Listing 18-18. Iterowanie dynamicznych właściwości
            foreach (KeyValuePair<string, object> prop in dx)
            {
                Console.WriteLine(prop.Key + ": " + prop.Value);
            }

            // Listing 18-19. Obiekt klasy ExpandoObject jako słownik i obiekt dynamiczny
            ExpandoObject xo = new ExpandoObject();
            IDictionary<string, object> dictionary = xo;
            dictionary["Foo"] = "Bar";
            dynamic dyn = xo;
            Console.WriteLine(dyn.Foo);
        }
    }
}
